/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Akiyoshi's Snakes Illusion
// Shader code by David Hoskins - 2013.
// This is my attempt at recreating an \"anomalous motion illusion\" from here:-
// http://www.ritsumei.ac.jp/~akitaoka/index-e.html
// *** This should be viewed full screen to work correctly. ***
//
// It is NOT ANIMATED, it just seems like it is!
// It works by using psychovisual research into how the brain interprets images
// in the visual cortex - cool huh?!
// You can stop it by staring at a single point,
// Can't make it stop? Then you're drinking too much coffee!! :)
// CAT's can see it too! Look:-
// http://www.youtube.com/watch?v=CcXXQ6GCUb8

float Circle ( vec2 p, float r )
{
    return length(p) - r;
}

vec3 Colour ( vec2 pos, float r, float odd )
{
    if ( r > .235 ) return vec3(0.0);

    vec3 rgb;

    r = pow(r,1.5) * 90.0;
    float ring = floor(r);

    r = pow(fract(r),1.0/1.5);

    float ang = atan(pos.x,pos.y)*6.37;
    ang += ring;

    float fra = fract(ang);
    float si = length(vec2(fra*1.25,r)-vec2(.5,.5)) - .5;

    if ( si <= 0.0 )
     {
       rgb = mix ( vec3(0.825,0.825,0.0), vec3(0.0,0.399,1.0), step(mod(ang+odd,2.0),1.0) );
     }
    else
     {
       rgb = mix ( vec3(0.0), vec3(1.0), step(mod(ang+0.5,2.0),1.0) );
     }

    return rgb;
}

void main(void)
{
    vec2 uv = (gl_FragCoord.xy/iResolution.xy)*2.0 - 1.0;

    uv   *= 0.85;
    uv.x *= iResolution.x / iResolution.y;

    vec2 pixelSize = vec2(1.0) / iResolution.xy;

    vec3 rgb = vec3(1.0);
    vec3 colAdd = vec3(0.0);

    float r = 0.0;

    // Anti-aliasing...

    float x = -1.0;
    float y = -1.0;

    int xi,yi;
    vec2 pos;
    float odd;

    for ( yi = 0; yi < 4; yi++)
     {
        x = -1.0;

        for (  xi = 0; xi < 4; xi++ )
         {
            rgb = vec3(1.0);

            pos = uv + vec2(0.0,0.25) + pixelSize*vec2(x,y) + 0.5;
            odd = mod ( abs(floor(pos.x*2.0)+floor(pos.y*2.0)), 2.0 );

            if ( length(max(abs(uv*vec2(0.5,1.0))-0.75,0.0)) <= 0.0 )
             {
                pos = mod(pos,0.5) - 0.25;
                r = Circle(abs(pos),0.25);
                if ( r < 0.0 ) rgb = Colour(pos,-r,odd);
             }

            if ( length(max(abs(uv*vec2(0.4,1.0))-0.5,0.0)) <= 0.0 )
             {
                pos = uv + vec2(0.0,0.25) + pixelSize*vec2(x,y) + 0.25;
                odd = mod ( abs(floor(pos.x*2.0)+floor(pos.y*2.0)), 2.0 );
                pos = mod(abs(pos),0.5)-0.25;
                r = Circle(pos,0.25);
                if ( r < 0.0 ) rgb = Colour(pos,-r,odd);
             }

            colAdd += rgb;
            x += 0.5;

         }

        y += 0.5;

    }

    gl_FragColor = vec4 ( colAdd/16.0, 1.0 );

}